package org.example;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class AlertingThreadPoolExecutor extends ThreadPoolExecutor {
    private CallbackInterface callback;

    public AlertingThreadPoolExecutor(CallbackInterface callback) {
        super(1, 1, 60, TimeUnit.SECONDS, new LinkedBlockingQueue<>(10));
        this.callback = callback;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null) {
            callback.taskDone("Task completed Executor");
        } else {
            // Handle task failure
        }
    }

    public static void main(String[] args) {
        Task task = new Task();
        Callback callback = new Callback();

        AlertingThreadPoolExecutor atpe = new AlertingThreadPoolExecutor(callback);
        atpe.execute(task);
        atpe.close();
    }
}